<?php

namespace Lavalite\Tasklist\Http\Controllers;

use App\Http\Controllers\PublicController as CMSPublicController;
use Lavalite\Tasklist\Interfaces\TaskRepositoryInterface;

class TaskPublicController extends CMSPublicController
{
    /**
     * Constructor.
     *
     * @param type \Lavalite\Task\Interfaces\TaskRepositoryInterface $task
     *
     * @return type
     */
    public function __construct(TaskRepositoryInterface $task)
    {
        $this->repository = $task;
        parent::__construct();
    }

    /**
     * Show task's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $tasks = $this->repository->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        return $this->theme->of('tasklist::public.task.index', compact('tasks'))->render();
    }

    /**
     * Show task.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $task = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->theme->of('tasklist::public.task.show', compact('task'))->render();
    }
}
