<?php

namespace Lavalite\Tasklist\Http\Controllers;

use App\Http\Controllers\UserController as UserController;
use Form;
use Lavalite\Tasklist\Http\Requests\TaskUserRequest;
use Lavalite\Tasklist\Interfaces\TaskRepositoryInterface;
use Lavalite\Tasklist\Models\Task;

class TaskUserController extends UserController
{
    /**
     * Initialize task controller.
     *
     * @param type TaskRepositoryInterface $task
     *
     * @return type
     */
    public function __construct(TaskRepositoryInterface $task)
    {
        $this->repository = $task;
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(TaskUserRequest $request)
    {
        $this->repository->pushCriteria(new \Lavalite\Tasklist\Repositories\Criteria\TaskUserCriteria());
        $tasks = $this->repository->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        $this->theme->prependTitle(trans('tasklist::task.names').' :: ');

        return $this->theme->of('tasklist::user.task.index', compact('tasks'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param Task $task
     *
     * @return Response
     */
    public function show(TaskUserRequest $request, Task $task)
    {
        Form::populate($task);

        return $this->theme->of('tasklist::user.task.show', compact('task'))->render();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(TaskUserRequest $request)
    {

        $task = $this->repository->newInstance([]);
        Form::populate($task);

        return $this->theme->of('tasklist::user.task.create', compact('task'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(TaskUserRequest $request)
    {
        try {
            $attributes = $request->all();
            $attributes['user_id'] = user_id();
            $task = $this->repository->create($attributes);

            $this->responseCode = 201;
            $this->responseMessage = trans('messages.success.created', ['Module' => trans('tasklist::task.name')]);
            $this->responseRedirect = trans_url('/user/tasklist/task');
            return $this -> respond($request);
        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param Task $task
     *
     * @return Response
     */
    public function edit(TaskUserRequest $request, Task $task)
    {

        Form::populate($task);

        return $this->theme->of('tasklist::user.task.edit', compact('task'))->render();
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param Task $task
     *
     * @return Response
     */
    public function update(TaskUserRequest $request, Task $task)
    {
        try {
            $this->repository->update($request->all(), $task->getRouteKey());
            $this->responseCode = 204;
            $this->responseMessage = trans('messages.success.updated', ['Module' => trans('tasklist::task.name')]);
            $this->responseRedirect = trans_url('/user/tasklist/task');
            return $this -> respond($request);
        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(TaskUserRequest $request, Task $task)
    {
        try {
            $this->repository->delete($task->getRouteKey());
            $this->responseCode = 204;
            $this->responseMessage = trans('messages.success.deleted', ['Module' => trans('tasklist::task.name')]);
            $this->responseRedirect = trans_url('/user/tasklist/task');
            return $this -> respond($request);
        } catch (Exception $e) {

            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);

        }
    }
}
