<?php

// Admin routes for task
Route::group(['prefix' => trans_setlocale().'/admin/tasklist', 'middleware' => ['web', 'auth.role:admin']], function () {
    Route::resource('task', 'Lavalite\Tasklist\Http\Controllers\TaskAdminController');
});

// User routes for task
Route::group(['prefix' => trans_setlocale().'/user/tasklist', 'middleware' => ['web', 'auth.role:user']], function () {
    Route::resource('task', 'Lavalite\Tasklist\Http\Controllers\TaskUserController');
});

// Public routes for task
Route::group(['prefix' => trans_setlocale(), 'middleware' => ['web']], function () {
    Route::get('tasklist/task', 'Lavalite\Tasklist\Http\Controllers\TaskPublicController@index');
    Route::get('tasklist/task/{slug?}', 'Lavalite\Tasklist\Http\Controllers\TaskPublicController@show');
});
