<?php

namespace Lavalite\Tasklist\Policies;

use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Lavalite\Tasklist\Models\Task;

class TaskPolicy
{
    use HandlesAuthorization;

    /**
     * Determine if the given user can view the task.
     *
     * @param User $user
     * @param Task $task
     *
     * @return bool
     */
    public function view(User $user, Task $task)
    {
        if ($user->canDo('tasklist.task.view') && $user->is('admin')) {
            return true;
        }

        return $user->id === $task->user_id;
    }

    /**
     * Determine if the given user can create a task.
     *
     * @param User $user
     * @param Task $task
     *
     * @return bool
     */
    public function create(User $user)
    {
        return  $user->canDo('tasklist.task.create');
    }

    /**
     * Determine if the given user can update the given task.
     *
     * @param User $user
     * @param Task $task
     *
     * @return bool
     */
    public function update(User $user, Task $task)
    {
        if ($user->canDo('tasklist.task.update') && $user->is('admin')) {
            return true;
        }

        return $user->id === $task->user_id;
    }

    /**
     * Determine if the given user can delete the given task.
     *
     * @param User $user
     * @param Task $task
     *
     * @return bool
     */
    public function delete(User $user, Task $task)
    {
        if ($user->canDo('tasklist.task.delete') && $user->is('admin')) {
            return true;
        }

        return $user->id === $task->user_id;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperUser()) {
            return true;
        }
    }
}
