<?php

namespace Lavalite\Tasklist\Providers;

use Illuminate\Support\ServiceProvider;

class TasklistServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../../../resources/views', 'tasklist');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../../../resources/lang', 'tasklist');

        // Call pblish redources function
        $this->publishResources();

        include __DIR__ . '/../Http/routes.php';
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('tasklist', function ($app) {
            return $this->app->make('Lavalite\Tasklist\Tasklist');
        });

        // Bind Task to repository
        $this->app->bind(
            \Lavalite\Tasklist\Interfaces\TaskRepositoryInterface::class,
            \Lavalite\Tasklist\Repositories\Eloquent\TaskRepository::class
        );

        $this->app->register(\Lavalite\Tasklist\Providers\AuthServiceProvider::class);
        $this->app->register(\Lavalite\Tasklist\Providers\EventServiceProvider::class);
        $this->app->register(\Lavalite\Tasklist\Providers\RouteServiceProvider::class);
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['tasklist'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../../../config/config.php' => config_path('package/tasklist.php')], 'config');

        // Publish public view
        $this->publishes([__DIR__ . '/../../../../resources/views/public'  => base_path('resources/views/vendor/tasklist/public')], 'view-public');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../../../resources/views/admin' => base_path('resources/views/vendor/tasklist/admin')], 'view-admin');

        // Publish language files
        $this->publishes([__DIR__ . '/../../../../resources/lang' => base_path('resources/lang/vendor/tasklist')], 'lang');

        // Publish migrations
        $this->publishes([__DIR__ . '/../../../../database/migrations/' => base_path('database/migrations')], 'migrations');

        // Publish seeds
        $this->publishes([__DIR__ . '/../../../../database/seeds/' => base_path('database/seeds')], 'seeds');
    }
}
