<?php

namespace Lavalite\Tasklist\Repositories\Eloquent;

use Lavalite\Tasklist\Interfaces\TaskRepositoryInterface;
use Litepie\Database\Eloquent\BaseRepository;

class TaskRepository extends BaseRepository implements TaskRepositoryInterface
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'name'  => 'like'
    ];

    public function boot()
    {
        $this->pushCriteria(app('Litepie\Database\Criteria\RequestCriteria'));
    }

    /**
     * Specify Model class name.
     *
     * @return string
     */
    public function model()
    {
        return config('package.tasklist.task.model');
    }
}
