<?php

namespace Testimonials\Testimonial\Seeders;

use DB;
use Illuminate\Database\Seeder;

class TestimonialsTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('testimonials')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'testimonial.testimonials.view',
                'name'      => 'View Testimonials',
            ],
            [
                'slug'      => 'testimonial.testimonials.create',
                'name'      => 'Create Testimonials',
            ],
            [
                'slug'      => 'testimonial.testimonials.edit',
                'name'      => 'Update Testimonials',
            ],
            [
                'slug'      => 'testimonial.testimonials.delete',
                'name'      => 'Delete Testimonials',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/testimonial/testimonials',
                'name'        => 'Testimonials',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/testimonial/testimonials',
                'name'        => 'Testimonials',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'testimonials',
                'name'        => 'Testimonials',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Testimonial',
                'module'    => 'Testimonials',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'testimonial.testimonials.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
