Lavalite package that provides testimonial management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `testimonials/testimonial`.

    "testimonials/testimonial": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Testimonials\Testimonial\Providers\TestimonialServiceProvider::class,

And also add it to alias

    'Testimonial'  => Testimonials\Testimonial\Facades\Testimonial::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Testimonials\\Testimonial\\Seeders\\TestimonialTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Testimonials\Testimonial\Providers\TestimonialServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Testimonials\Testimonial\Providers\TestimonialServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Testimonials\Testimonial\Providers\TestimonialServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/testimonial/{modulename}

**User**

    http://path-to-route-folder/user/testimonial/{modulename}

**Public**

    http://path-to-route-folder/testimonials


### API endpoints

**List**

    http://path-to-route-folder/api/user/testimonial/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/testimonial/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/testimonial/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/testimonial/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/testimonial/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/testimonial/{modulename}/{slug}
    METHOD: GET