<?php

namespace Testimonials\Testimonial\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Database\RequestScope;
use Testimonials\Testimonial\Http\Resources\TestimonialResource;
use Testimonials\Testimonial\Http\Resources\TestimonialsCollection;
use Testimonials\Testimonial\Scopes\TestimonialsPublicScope;
use Testimonials\Testimonial\Models\Testimonials;

class TestimonialsPublicController extends BaseController
{

    /**
     * Show testimonials's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $page = Testimonials::pushScope(new RequestScope())
            ->pushScope(new TestimonialsPublicScope())
            ->select('testimonials.*')
            ->paginate($pageLimit)
            ->withQueryString();

        $data = new TestimonialsCollection($page);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('testimonial::testimonials.names'))
            ->view('testimonial::public.testimonials.index')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show testimonials.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $model = Testimonials::findBySlug($slug);
        $data = new TestimonialsResource($model);

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('testimonial::testimonials.name'))
            ->view('testimonial::public.testimonials.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
