<?php

namespace Testimonials\Testimonial\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Testimonials\Testimonial\Models\Testimonials;

class TestimonialsPolicy
{

    /**
     * Determine if the given user can view the testimonials.
     *
     * @param UserPolicyInterface $authUser
     * @param Testimonials $testimonials
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Testimonials $testimonials)
    {
        if ($authUser->canDo('testimonial.testimonials.view') && $authUser->isAdmin()) {
            return true;
        }

        return $testimonials->user_id == user_id() && $testimonials->user_type == user_type();
    }

    /**
     * Determine if the given user can create a testimonials.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('testimonial.testimonials.create');
    }

    /**
     * Determine if the given user can update the given testimonials.
     *
     * @param UserPolicyInterface $authUser
     * @param Testimonials $testimonials
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Testimonials $testimonials)
    {
        if ($authUser->canDo('testimonial.testimonials.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $testimonials->user_id == user_id() && $testimonials->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given testimonials.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Testimonials $testimonials)
    {
        return $testimonials->user_id == user_id() && $testimonials->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given testimonials.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Testimonials $testimonials)
    {
        if ($authUser->canDo('testimonial.testimonials.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given testimonials.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Testimonials $testimonials)
    {
        if ($authUser->canDo('testimonial.testimonials.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
