<?php

namespace Testimonials\Testimonial\Providers;

use Illuminate\Support\ServiceProvider;
use Testimonials\Testimonial\Testimonials;

class TestimonialServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'testimonial');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'testimonial');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        // $this->registerCommands();

        $this->app->register(\Testimonials\Testimonial\Providers\AuthServiceProvider::class);
        $this->app->register(\Testimonials\Testimonial\Providers\RouteServiceProvider::class);
        // $this->app->register(\Testimonials\Testimonial\Providers\EventServiceProvider::class);
        // $this->app->register(\Testimonials\Testimonial\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('testimonials.testimonial', function($app)
        {
            return $this->app->make(Testimonials::class);
        });
    }



    /**
     * Merges user's and testimonial's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'testimonials.testimonial'
        );
        
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/testimonials.php', 'testimonials.testimonial.testimonials'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Testimonials\Testimonial\Commands\Testimonial::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['testimonials.testimonial'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('testimonials/testimonial')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/testimonial')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/testimonial')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
