<?php

namespace Testing;

use DB;
use Illuminate\Database\Seeder;

class TestingTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('testings')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'testing.testing.view',
                'name'      => 'View Testing',
            ],
            [
                'slug'      => 'testing.testing.create',
                'name'      => 'Create Testing',
            ],
            [
                'slug'      => 'testing.testing.edit',
                'name'      => 'Update Testing',
            ],
            [
                'slug'      => 'testing.testing.delete',
                'name'      => 'Delete Testing',
            ],
            
            // Customize this permissions if needed.
            [
                'slug'      => 'testing.testing.verify',
                'name'      => 'Verify Testing',
            ],
            [
                'slug'      => 'testing.testing.approve',
                'name'      => 'Approve Testing',
            ],
            [
                'slug'      => 'testing.testing.publish',
                'name'      => 'Publish Testing',
            ],
            [
                'slug'      => 'testing.testing.unpublish',
                'name'      => 'Unpublish Testing',
            ],
            [
                'slug'      => 'testing.testing.cancel',
                'name'      => 'Cancel Testing',
            ],
            [
                'slug'      => 'testing.testing.archive',
                'name'      => 'Archive Testing',
            ],
            
        ]);

        DB::table('menus')->insert([

            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/testing/testing',
                'name'        => 'Testing',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/testing/testing',
                'name'        => 'Testing',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'testing',
                'name'        => 'Testing',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Testing',
                'module'    => 'Testing',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'testing.testing.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
