<?php

namespace Testing\Testing\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Testing\Testing\Interfaces\TestingRepositoryInterface;

class TestingPublicController extends BaseController
{
    // use TestingWorkflow;

    /**
     * Constructor.
     *
     * @param type \Testing\Testing\Interfaces\TestingRepositoryInterface $testing
     *
     * @return type
     */
    public function __construct(TestingRepositoryInterface $testing)
    {
        $this->repository = $testing;
        parent::__construct();
    }

    /**
     * Show testing's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $testings = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$testing::$testing.names'))
            ->view('$testing::public.testing.index')
            ->data(compact('$testings'))
            ->output();
    }

    /**
     * Show testing's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $testings = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$testing::$testing.names'))
            ->view('$testing::public.testing.index')
            ->data(compact('$testings'))
            ->output();
    }

    /**
     * Show testing.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $testing = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$testing->name . trans('$testing::$testing.name'))
            ->view('$testing::public.testing.show')
            ->data(compact('$testing'))
            ->output();
    }

}
