<?php

namespace Testing\Testing\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Testing\Testing\Http\Requests\TestingRequest;
use Testing\Testing\Models\Testing;

/**
 * Admin web controller class.
 */
class TestingWorkflowController extends BaseController
{

    /**
     * Workflow controller function for testing.
     *
     * @param Model   $testing
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(TestingRequest $request, Testing $testing, $step)
    {

        try {

            $testing->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('testing::testing.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/testing/testing/' . $testing->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/testing/testing/' . $testing->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for testing.
     *
     * @param Model   $testing
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
     */

    public function getWorkflow(Testing $testing, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $testing->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('testing::testing.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('testing::admin.testing.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('testing::admin.testing.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('testing::admin.testing.message', $data)->render();

        }

    }
}
