<?php

namespace Testing\Testing\Policies;

use Litepie\User\Contracts\UserPolicy;
use Testing\Testing\Models\Testing;

class TestingPolicy
{

    /**
     * Determine if the given user can view the testing.
     *
     * @param UserPolicy $user
     * @param Testing $testing
     *
     * @return bool
     */
    public function view(UserPolicy $user, Testing $testing)
    {
        if ($user->canDo('testing.testing.view') && $user->isAdmin()) {
            return true;
        }

        return $testing->user_id == user_id() && $testing->user_type == user_type();
    }

    /**
     * Determine if the given user can create a testing.
     *
     * @param UserPolicy $user
     * @param Testing $testing
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('testing.testing.create');
    }

    /**
     * Determine if the given user can update the given testing.
     *
     * @param UserPolicy $user
     * @param Testing $testing
     *
     * @return bool
     */
    public function update(UserPolicy $user, Testing $testing)
    {
        if ($user->canDo('testing.testing.edit') && $user->isAdmin()) {
            return true;
        }

        return $testing->user_id == user_id() && $testing->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given testing.
     *
     * @param UserPolicy $user
     * @param Testing $testing
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Testing $testing)
    {
        return $testing->user_id == user_id() && $testing->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given testing.
     *
     * @param UserPolicy $user
     * @param Testing $testing
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Testing $testing)
    {
        if ($user->canDo('testing.testing.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given testing.
     *
     * @param UserPolicy $user
     * @param Testing $testing
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Testing $testing)
    {
        if ($user->canDo('testing.testing.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
