<?php

namespace Testing\Testing\Providers;

use Illuminate\Support\ServiceProvider;

class TestingServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'testing');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'testing');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('testing.testing', function ($app) {
            return $this->app->make('Testing\Testing\Testing');
        });

                // Bind Testing to repository
        $this->app->bind(
            'Testing\Testing\Interfaces\TestingRepositoryInterface',
            \Testing\Testing\Repositories\Eloquent\TestingRepository::class
        );

        $this->app->register(\Testing\Testing\Providers\AuthServiceProvider::class);
                $this->app->register(\Testing\Testing\Providers\EventServiceProvider::class);
        
        $this->app->register(\Testing\Testing\Providers\RouteServiceProvider::class);
                $this->app->register(\Testing\Testing\Providers\WorkflowServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['testing.testing'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('testing/testing.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/testing')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/testing')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
