<?php

namespace Testing\Testing\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class TestingTransformer extends TransformerAbstract
{
    public function transform(\Testing\Testing\Models\Testing $testing)
    {
        return [
            'id'                => $testing->getRouteKey(),
            'key'               => [
                'public'    => $testing->getPublicKey(),
                'route'     => $testing->getRouteKey(),
            ], 
            ''                  => $testing->,
            'url'               => [
                'public'    => trans_url('testing/'.$testing->getPublicKey()),
                'user'      => guard_url('testing/testing/'.$testing->getRouteKey()),
            ], 
            'status'            => trans('app.'.$testing->status),
            'created_at'        => format_date($testing->created_at),
            'updated_at'        => format_date($testing->updated_at),
        ];
    }
}