<?php

namespace Testing\Testing;

use User;

class Testing
{
    /**
     * $testing object.
     */
    protected $testing;

    /**
     * Constructor.
     */
    public function __construct(\Testing\Testing\Interfaces\TestingRepositoryInterface $testing)
    {
        $this->testing = $testing;
    }

    /**
     * Returns count of testing.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.testing.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->testing->pushCriteria(new \Litepie\Testing\Repositories\Criteria\TestingUserCriteria());
        }

        $testing = $this->testing->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('testing::' . $view, compact('testing'))->render();
    }
}
