<?php

namespace Testing\Testing\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Testing\Testing\Models\Testing;

class TestingAction
{
    /**
     * Perform the complete action.
     *
     * @param Testing $testing
     *
     * @return Testing
     */
    public function complete(Testing $testing)
    {
        try {
            $testing->status = 'complete';
            return $testing->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Testing $testing
     *
     * @return Testing
     */public function verify(Testing $testing)
    {
        try {
            $testing->status = 'verify';
            return $testing->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Testing $testing
     *
     * @return Testing
     */public function approve(Testing $testing)
    {
        try {
            $testing->status = 'approve';
            return $testing->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Testing $testing
     *
     * @return Testing
     */public function publish(Testing $testing)
    {
        try {
            $testing->status = 'publish';
            return $testing->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Testing $testing
     *
     * @return Testing
     */
    public function archive(Testing $testing)
    {
        try {
            $testing->status = 'archive';
            return $testing->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Testing $testing
     *
     * @return Testing
     */
    public function unpublish(Testing $testing)
    {
        try {
            $testing->status = 'unpublish';
            return $testing->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
