<?php

namespace Testing\Testing\Workflow;

use Testing\Testing\Models\Testing;
use Testing\Testing\Notifications\TestingWorkflow as TestingNotifyer;
use Notification;

class TestingNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Testing $testing
     *
     * @return void
     */
    public function complete(Testing $testing)
    {
        return Notification::send($testing->user, new TestingNotifyer($testing, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Testing $testing
     *
     * @return void
     */
    public function verify(Testing $testing)
    {
        return Notification::send($testing->user, new TestingNotifyer($testing, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Testing $testing
     *
     * @return void
     */
    public function approve(Testing $testing)
    {
        return Notification::send($testing->user, new TestingNotifyer($testing, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Testing $testing
     *
     * @return void
     */
    public function publish(Testing $testing)
    {
        return Notification::send($testing->user, new TestingNotifyer($testing, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Testing $testing
     *
     * @return void
     */
    public function archive(Testing $testing)
    {
        return Notification::send($testing->user, new TestingNotifyer($testing, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Testing $testing
     *
     * @return void
     */
    public function unpublish(Testing $testing)
    {
        return Notification::send($testing->user, new TestingNotifyer($testing, 'unpublish'));;

    }
}
