<?php

namespace Testing\Testing\Workflow;

use Testing\Testing\Models\Testing;
use Validator;

class TestingValidator
{

    /**
     * Determine if the given testing is valid for complete status.
     *
     * @param Testing $testing
     *
     * @return bool / Validator
     */
    public function complete(Testing $testing)
    {
        return Validator::make($testing->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given testing is valid for verify status.
     *
     * @param Testing $testing
     *
     * @return bool / Validator
     */
    public function verify(Testing $testing)
    {
        return Validator::make($testing->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given testing is valid for approve status.
     *
     * @param Testing $testing
     *
     * @return bool / Validator
     */
    public function approve(Testing $testing)
    {
        return Validator::make($testing->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given testing is valid for publish status.
     *
     * @param Testing $testing
     *
     * @return bool / Validator
     */
    public function publish(Testing $testing)
    {
        return Validator::make($testing->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given testing is valid for archive status.
     *
     * @param Testing $testing
     *
     * @return bool / Validator
     */
    public function archive(Testing $testing)
    {
        return Validator::make($testing->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given testing is valid for unpublish status.
     *
     * @param Testing $testing
     *
     * @return bool / Validator
     */
    public function unpublish(Testing $testing)
    {
        return Validator::make($testing->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
