<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'school',

    /*
     * Package.
     */
    'package'   => 'school',

    /*
     * Modules.
     */
    'modules'   => ['school', 'student'],

    'school'       => [
        'model' => [
            'model'                 => \School\School\Models\School::class,
            'table'                 => 'schools',
            'presenter'             => \School\School\Repositories\Presenter\SchoolPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'name'],
            'translatables'         => [],
            'upload_folder'         => 'school/school',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'School',
            'package'   => 'School',
            'module'    => 'School',
        ],

    ],
    'student'       => [
        'model' => [
            'model'                 => \School\School\Models\Student::class,
            'table'                 => 'students',
            'presenter'             => \School\School\Repositories\Presenter\StudentPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'school_id'],
            'translatables'         => [],
            'upload_folder'         => 'school/student',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'School',
            'package'   => 'School',
            'module'    => 'Student',
        ],

    ],
];
