@extends('resource.show')

@php
$links['back'] = guard_url('school/school');
$links['edit'] = guard_url('school/school') . '/' . $school->getRouteKey() . '/edit';
@endphp

@section('icon') 
<i class="pe-7s-display2"></i>
@stop

@section('title') 
{!! __('school::school.title.main') !!}
@stop

@section('sub.title') 
{!! __('school::school.title.show') !!}
@stop

@section('breadcrumb') 
  <li><a href="{!!guard_url('/')!!}">{{ __('app.home') }}</a></li>
  <li><a href="{!!guard_url('$school/school')!!}">{!! __('school::school.name') !!}</a></li>
  <li>{{ __('app.show') }}</li>
@stop

@section('tabs') 
@stop

@section('tools') 
    <a href="{!!guard_url('$school/school')!!}" rel="tooltip" class="btn btn-white btn-round btn-simple btn-icon pull-right add-new" data-original-title="" title="">
            <i class="fa fa-chevron-left"></i>
    </a>
@stop

@section('content') 
    @include('school::school.partial.show', ['mode' => 'show'])
@stop
