<?php

namespace School\School\Policies;

use Litepie\User\Contracts\UserPolicy;
use School\School\Models\School;

class SchoolPolicy
{

    /**
     * Determine if the given user can view the school.
     *
     * @param UserPolicy $user
     * @param School $school
     *
     * @return bool
     */
    public function view(UserPolicy $user, School $school)
    {
        if ($user->canDo('school.school.view') && $user->isAdmin()) {
            return true;
        }

        return $school->user_id == user_id() && $school->user_type == user_type();
    }

    /**
     * Determine if the given user can create a school.
     *
     * @param UserPolicy $user
     * @param School $school
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('school.school.create');
    }

    /**
     * Determine if the given user can update the given school.
     *
     * @param UserPolicy $user
     * @param School $school
     *
     * @return bool
     */
    public function update(UserPolicy $user, School $school)
    {
        if ($user->canDo('school.school.edit') && $user->isAdmin()) {
            return true;
        }

        return $school->user_id == user_id() && $school->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given school.
     *
     * @param UserPolicy $user
     * @param School $school
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, School $school)
    {
        return $school->user_id == user_id() && $school->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given school.
     *
     * @param UserPolicy $user
     * @param School $school
     *
     * @return bool
     */
    public function verify(UserPolicy $user, School $school)
    {
        if ($user->canDo('school.school.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given school.
     *
     * @param UserPolicy $user
     * @param School $school
     *
     * @return bool
     */
    public function approve(UserPolicy $user, School $school)
    {
        if ($user->canDo('school.school.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
