<?php

namespace School\School\Policies;

use Litepie\User\Contracts\UserPolicy;
use School\School\Models\Student;

class StudentPolicy
{

    /**
     * Determine if the given user can view the student.
     *
     * @param UserPolicy $user
     * @param Student $student
     *
     * @return bool
     */
    public function view(UserPolicy $user, Student $student)
    {
        if ($user->canDo('school.student.view') && $user->isAdmin()) {
            return true;
        }

        return $student->user_id == user_id() && $student->user_type == user_type();
    }

    /**
     * Determine if the given user can create a student.
     *
     * @param UserPolicy $user
     * @param Student $student
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('school.student.create');
    }

    /**
     * Determine if the given user can update the given student.
     *
     * @param UserPolicy $user
     * @param Student $student
     *
     * @return bool
     */
    public function update(UserPolicy $user, Student $student)
    {
        if ($user->canDo('school.student.edit') && $user->isAdmin()) {
            return true;
        }

        return $student->user_id == user_id() && $student->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given student.
     *
     * @param UserPolicy $user
     * @param Student $student
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Student $student)
    {
        return $student->user_id == user_id() && $student->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given student.
     *
     * @param UserPolicy $user
     * @param Student $student
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Student $student)
    {
        if ($user->canDo('school.student.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given student.
     *
     * @param UserPolicy $user
     * @param Student $student
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Student $student)
    {
        if ($user->canDo('school.student.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
