<?php

namespace School\School\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class SchoolTransformer extends TransformerAbstract
{
    public function transform(\School\School\Models\School $school)
    {
        return [
            'id'                => $school->getRouteKey(),
            'key'               => [
                'public'    => $school->getPublicKey(),
                'route'     => $school->getRouteKey(),
            ], 
            'id'                => $school->id,
            'name'              => $school->name,
            'url'               => [
                'public'    => trans_url('school/'.$school->getPublicKey()),
                'user'      => guard_url('school/school/'.$school->getRouteKey()),
            ], 
            'status'            => trans('app.'.$school->status),
            'created_at'        => format_date($school->created_at),
            'updated_at'        => format_date($school->updated_at),
        ];
    }
}