<?php

namespace School\School\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class StudentTransformer extends TransformerAbstract
{
    public function transform(\School\School\Models\Student $student)
    {
        return [
            'id'                => $student->getRouteKey(),
            'key'               => [
                'public'    => $student->getPublicKey(),
                'route'     => $student->getRouteKey(),
            ], 
            'id'                => $student->id,
            'school_id'         => $student->school_id,
            'url'               => [
                'public'    => trans_url('school/'.$student->getPublicKey()),
                'user'      => guard_url('school/student/'.$student->getRouteKey()),
            ], 
            'status'            => trans('app.'.$student->status),
            'created_at'        => format_date($student->created_at),
            'updated_at'        => format_date($student->updated_at),
        ];
    }
}