<?php

namespace School\School;

use User;

class School
{
    /**
     * $school object.
     */
    protected $school;    /**
     * $student object.
     */
    protected $student;

    /**
     * Constructor.
     */
    public function __construct(\School\School\Interfaces\SchoolRepositoryInterface $school,        \School\School\Interfaces\StudentRepositoryInterface $student)
    {
        $this->school = $school;        $this->student = $student;
    }

    /**
     * Returns count of school.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.school.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->school->pushCriteria(new \Litepie\School\Repositories\Criteria\SchoolUserCriteria());
        }

        $school = $this->school->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('school::' . $view, compact('school'))->render();
    }    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.student.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->student->pushCriteria(new \Litepie\School\Repositories\Criteria\StudentUserCriteria());
        }

        $student = $this->student->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('school::' . $view, compact('student'))->render();
    }
}
