<?php

namespace Testing;

use DB;
use Illuminate\Database\Seeder;

class TestingTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('nices')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'testing.nice.view',
                'name'      => 'View Nice',
            ],
            [
                'slug'      => 'testing.nice.create',
                'name'      => 'Create Nice',
            ],
            [
                'slug'      => 'testing.nice.edit',
                'name'      => 'Update Nice',
            ],
            [
                'slug'      => 'testing.nice.delete',
                'name'      => 'Delete Nice',
            ],
            
            // Customize this permissions if needed.
            [
                'slug'      => 'testing.nice.verify',
                'name'      => 'Verify Nice',
            ],
            [
                'slug'      => 'testing.nice.approve',
                'name'      => 'Approve Nice',
            ],
            [
                'slug'      => 'testing.nice.publish',
                'name'      => 'Publish Nice',
            ],
            [
                'slug'      => 'testing.nice.unpublish',
                'name'      => 'Unpublish Nice',
            ],
            [
                'slug'      => 'testing.nice.cancel',
                'name'      => 'Cancel Nice',
            ],
            [
                'slug'      => 'testing.nice.archive',
                'name'      => 'Archive Nice',
            ],
            
        ]);

        DB::table('menus')->insert([

            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/testing/nice',
                'name'        => 'Nice',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/testing/nice',
                'name'        => 'Nice',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'nice',
                'name'        => 'Nice',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Testing',
                'module'    => 'Nice',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'testing.nice.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
