<?php

namespace Testing\Testing\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Testing\Testing\Interfaces\NiceRepositoryInterface;

class NicePublicController extends BaseController
{
    // use NiceWorkflow;

    /**
     * Constructor.
     *
     * @param type \Testing\Nice\Interfaces\NiceRepositoryInterface $nice
     *
     * @return type
     */
    public function __construct(NiceRepositoryInterface $nice)
    {
        $this->repository = $nice;
        parent::__construct();
    }

    /**
     * Show nice's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $nices = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$testing::$nice.names'))
            ->view('$testing::public.nice.index')
            ->data(compact('$nices'))
            ->output();
    }

    /**
     * Show nice's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $nices = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$testing::$nice.names'))
            ->view('$testing::public.nice.index')
            ->data(compact('$nices'))
            ->output();
    }

    /**
     * Show nice.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $nice = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$nice->name . trans('$testing::$nice.name'))
            ->view('$testing::public.nice.show')
            ->data(compact('$nice'))
            ->output();
    }

}
