<?php

namespace Testing\Testing\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Testing\Testing\Http\Requests\NiceRequest;
use Testing\Testing\Models\Nice;

/**
 * Admin web controller class.
 */
class NiceWorkflowController extends BaseController
{

    /**
     * Workflow controller function for nice.
     *
     * @param Model   $nice
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(NiceRequest $request, Nice $nice, $step)
    {

        try {

            $nice->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('testing::nice.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/nice/nice/' . $nice->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/nice/nice/' . $nice->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for nice.
     *
     * @param Model   $nice
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
     */

    public function getWorkflow(Nice $nice, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $nice->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('testing::nice.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('testing::admin.nice.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('testing::admin.nice.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('testing::admin.nice.message', $data)->render();

        }

    }
}
