<?php

namespace Testing\Testing\Policies;

use Litepie\User\Contracts\UserPolicy;
use Testing\Testing\Models\Nice;

class NicePolicy
{

    /**
     * Determine if the given user can view the nice.
     *
     * @param UserPolicy $user
     * @param Nice $nice
     *
     * @return bool
     */
    public function view(UserPolicy $user, Nice $nice)
    {
        if ($user->canDo('testing.nice.view') && $user->isAdmin()) {
            return true;
        }

        return $nice->user_id == user_id() && $nice->user_type == user_type();
    }

    /**
     * Determine if the given user can create a nice.
     *
     * @param UserPolicy $user
     * @param Nice $nice
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('testing.nice.create');
    }

    /**
     * Determine if the given user can update the given nice.
     *
     * @param UserPolicy $user
     * @param Nice $nice
     *
     * @return bool
     */
    public function update(UserPolicy $user, Nice $nice)
    {
        if ($user->canDo('testing.nice.edit') && $user->isAdmin()) {
            return true;
        }

        return $nice->user_id == user_id() && $nice->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given nice.
     *
     * @param UserPolicy $user
     * @param Nice $nice
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Nice $nice)
    {
        return $nice->user_id == user_id() && $nice->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given nice.
     *
     * @param UserPolicy $user
     * @param Nice $nice
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Nice $nice)
    {
        if ($user->canDo('testing.nice.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given nice.
     *
     * @param UserPolicy $user
     * @param Nice $nice
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Nice $nice)
    {
        if ($user->canDo('testing.nice.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
