<?php

namespace Testing\Testing\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class NiceTransformer extends TransformerAbstract
{
    public function transform(\Testing\Testing\Models\Nice $nice)
    {
        return [
            'id'                => $nice->getRouteKey(),
            'key'               => [
                'public'    => $nice->getPublicKey(),
                'route'     => $nice->getRouteKey(),
            ], 
            'var'               => $nice->var,
            'url'               => [
                'public'    => trans_url('testing/'.$nice->getPublicKey()),
                'user'      => guard_url('testing/nice/'.$nice->getRouteKey()),
            ], 
            'status'            => trans('app.'.$nice->status),
            'created_at'        => format_date($nice->created_at),
            'updated_at'        => format_date($nice->updated_at),
        ];
    }
}