<?php

namespace Testing\Testing;

use User;

class Testing
{
    /**
     * $nice object.
     */
    protected $nice;

    /**
     * Constructor.
     */
    public function __construct(\Testing\Testing\Interfaces\NiceRepositoryInterface $nice)
    {
        $this->nice = $nice;
    }

    /**
     * Returns count of testing.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.nice.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->nice->pushCriteria(new \Litepie\Testing\Repositories\Criteria\NiceUserCriteria());
        }

        $nice = $this->nice->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('testing::' . $view, compact('nice'))->render();
    }
}
