<?php

namespace Testing\Testing\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Testing\Testing\Models\Nice;

class NiceAction
{
    /**
     * Perform the complete action.
     *
     * @param Nice $nice
     *
     * @return Nice
     */
    public function complete(Nice $nice)
    {
        try {
            $nice->status = 'complete';
            return $nice->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Nice $nice
     *
     * @return Nice
     */public function verify(Nice $nice)
    {
        try {
            $nice->status = 'verify';
            return $nice->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Nice $nice
     *
     * @return Nice
     */public function approve(Nice $nice)
    {
        try {
            $nice->status = 'approve';
            return $nice->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Nice $nice
     *
     * @return Nice
     */public function publish(Nice $nice)
    {
        try {
            $nice->status = 'publish';
            return $nice->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Nice $nice
     *
     * @return Nice
     */
    public function archive(Nice $nice)
    {
        try {
            $nice->status = 'archive';
            return $nice->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Nice $nice
     *
     * @return Nice
     */
    public function unpublish(Nice $nice)
    {
        try {
            $nice->status = 'unpublish';
            return $nice->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
