<?php

namespace Testing\Testing\Workflow;

use Testing\Testing\Models\Nice;
use Testing\Testing\Notifications\NiceWorkflow as NiceNotifyer;
use Notification;

class NiceNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Nice $nice
     *
     * @return void
     */
    public function complete(Nice $nice)
    {
        return Notification::send($nice->user, new NiceNotifyer($nice, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Nice $nice
     *
     * @return void
     */
    public function verify(Nice $nice)
    {
        return Notification::send($nice->user, new NiceNotifyer($nice, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Nice $nice
     *
     * @return void
     */
    public function approve(Nice $nice)
    {
        return Notification::send($nice->user, new NiceNotifyer($nice, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Nice $nice
     *
     * @return void
     */
    public function publish(Nice $nice)
    {
        return Notification::send($nice->user, new NiceNotifyer($nice, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Nice $nice
     *
     * @return void
     */
    public function archive(Nice $nice)
    {
        return Notification::send($nice->user, new NiceNotifyer($nice, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Nice $nice
     *
     * @return void
     */
    public function unpublish(Nice $nice)
    {
        return Notification::send($nice->user, new NiceNotifyer($nice, 'unpublish'));;

    }
}
