<?php

namespace Testing\Testing\Workflow;

use Testing\Testing\Models\Nice;
use Validator;

class NiceValidator
{

    /**
     * Determine if the given nice is valid for complete status.
     *
     * @param Nice $nice
     *
     * @return bool / Validator
     */
    public function complete(Nice $nice)
    {
        return Validator::make($nice->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given nice is valid for verify status.
     *
     * @param Nice $nice
     *
     * @return bool / Validator
     */
    public function verify(Nice $nice)
    {
        return Validator::make($nice->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given nice is valid for approve status.
     *
     * @param Nice $nice
     *
     * @return bool / Validator
     */
    public function approve(Nice $nice)
    {
        return Validator::make($nice->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given nice is valid for publish status.
     *
     * @param Nice $nice
     *
     * @return bool / Validator
     */
    public function publish(Nice $nice)
    {
        return Validator::make($nice->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given nice is valid for archive status.
     *
     * @param Nice $nice
     *
     * @return bool / Validator
     */
    public function archive(Nice $nice)
    {
        return Validator::make($nice->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given nice is valid for unpublish status.
     *
     * @param Nice $nice
     *
     * @return bool / Validator
     */
    public function unpublish(Nice $nice)
    {
        return Validator::make($nice->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
