<?php

namespace Litepie;

use DB;
use Illuminate\Database\Seeder;

class WorkflowTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('processes')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'workflow.process.view',
                'name'      => 'View Process',
            ],
            [
                'slug'      => 'workflow.process.create',
                'name'      => 'Create Process',
            ],
            [
                'slug'      => 'workflow.process.edit',
                'name'      => 'Update Process',
            ],
            [
                'slug'      => 'workflow.process.delete',
                'name'      => 'Delete Process',
            ],
            
            // Customize this permissions if needed.
            [
                'slug'      => 'workflow.process.verify',
                'name'      => 'Verify Process',
            ],
            [
                'slug'      => 'workflow.process.approve',
                'name'      => 'Approve Process',
            ],
            [
                'slug'      => 'workflow.process.publish',
                'name'      => 'Publish Process',
            ],
            [
                'slug'      => 'workflow.process.unpublish',
                'name'      => 'Unpublish Process',
            ],
            [
                'slug'      => 'workflow.process.cancel',
                'name'      => 'Cancel Process',
            ],
            [
                'slug'      => 'workflow.process.archive',
                'name'      => 'Archive Process',
            ],
            
        ]);

        DB::table('menus')->insert([

            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/workflow/process',
                'name'        => 'Process',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/workflow/process',
                'name'        => 'Process',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'process',
                'name'        => 'Process',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Workflow',
                'module'    => 'Process',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'workflow.process.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
