<?php

namespace Litepie\Workflow\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Litepie\Workflow\Http\Requests\ProcessRequest;
use Litepie\Workflow\Models\Process;

/**
 * Admin web controller class.
 */
class ProcessWorkflowController extends BaseController
{

    /**
     * Workflow controller function for process.
     *
     * @param Model   $process
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(ProcessRequest $request, Process $process, $step)
    {

        try {

            $process->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('workflow::process.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/process/process/' . $process->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/process/process/' . $process->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for process.
     *
     * @param Model   $process
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
     */

    public function getWorkflow(Process $process, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $process->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('workflow::process.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('workflow::admin.process.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('workflow::admin.process.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('workflow::admin.process.message', $data)->render();

        }

    }
}
