<?php

namespace Litepie\Workflow\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litepie\Workflow\Models\Process;

class ProcessPolicy
{

    /**
     * Determine if the given user can view the process.
     *
     * @param UserPolicy $user
     * @param Process $process
     *
     * @return bool
     */
    public function view(UserPolicy $user, Process $process)
    {
        if ($user->canDo('workflow.process.view') && $user->isAdmin()) {
            return true;
        }

        return $process->user_id == user_id() && $process->user_type == user_type();
    }

    /**
     * Determine if the given user can create a process.
     *
     * @param UserPolicy $user
     * @param Process $process
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('workflow.process.create');
    }

    /**
     * Determine if the given user can update the given process.
     *
     * @param UserPolicy $user
     * @param Process $process
     *
     * @return bool
     */
    public function update(UserPolicy $user, Process $process)
    {
        if ($user->canDo('workflow.process.edit') && $user->isAdmin()) {
            return true;
        }

        return $process->user_id == user_id() && $process->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given process.
     *
     * @param UserPolicy $user
     * @param Process $process
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Process $process)
    {
        return $process->user_id == user_id() && $process->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given process.
     *
     * @param UserPolicy $user
     * @param Process $process
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Process $process)
    {
        if ($user->canDo('workflow.process.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given process.
     *
     * @param UserPolicy $user
     * @param Process $process
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Process $process)
    {
        if ($user->canDo('workflow.process.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
