<?php

namespace Litepie\Workflow\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class ProcessTransformer extends TransformerAbstract
{
    public function transform(\Litepie\Workflow\Models\Process $process)
    {
        return [
            'id'                => $process->getRouteKey(),
            'key'               => [
                'public'    => $process->getPublicKey(),
                'route'     => $process->getRouteKey(),
            ], 
            'id'                => $process->id,
            'name'              => $process->name,
            'url'               => [
                'public'    => trans_url('workflow/'.$process->getPublicKey()),
                'user'      => guard_url('workflow/process/'.$process->getRouteKey()),
            ], 
            'status'            => trans('app.'.$process->status),
            'created_at'        => format_date($process->created_at),
            'updated_at'        => format_date($process->updated_at),
        ];
    }
}