<?php

namespace Litepie\Workflow;

use User;

class Workflow
{
    /**
     * $process object.
     */
    protected $process;

    /**
     * Constructor.
     */
    public function __construct(\Litepie\Workflow\Interfaces\ProcessRepositoryInterface $process)
    {
        $this->process = $process;
    }

    /**
     * Returns count of workflow.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.process.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->process->pushCriteria(new \Litepie\Litepie\Repositories\Criteria\ProcessUserCriteria());
        }

        $process = $this->process->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('workflow::' . $view, compact('process'))->render();
    }
}
