<?php

namespace Litepie\Workflow\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Litepie\Workflow\Models\Process;

class ProcessAction
{
    /**
     * Perform the complete action.
     *
     * @param Process $process
     *
     * @return Process
     */
    public function complete(Process $process)
    {
        try {
            $process->status = 'complete';
            return $process->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Process $process
     *
     * @return Process
     */public function verify(Process $process)
    {
        try {
            $process->status = 'verify';
            return $process->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Process $process
     *
     * @return Process
     */public function approve(Process $process)
    {
        try {
            $process->status = 'approve';
            return $process->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Process $process
     *
     * @return Process
     */public function publish(Process $process)
    {
        try {
            $process->status = 'publish';
            return $process->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Process $process
     *
     * @return Process
     */
    public function archive(Process $process)
    {
        try {
            $process->status = 'archive';
            return $process->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Process $process
     *
     * @return Process
     */
    public function unpublish(Process $process)
    {
        try {
            $process->status = 'unpublish';
            return $process->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
