<?php

namespace Litepie\Workflow\Workflow;

use Litepie\Workflow\Models\Process;
use Litepie\Workflow\Notifications\ProcessWorkflow as ProcessNotifyer;
use Notification;

class ProcessNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Process $process
     *
     * @return void
     */
    public function complete(Process $process)
    {
        return Notification::send($process->user, new ProcessNotifyer($process, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Process $process
     *
     * @return void
     */
    public function verify(Process $process)
    {
        return Notification::send($process->user, new ProcessNotifyer($process, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Process $process
     *
     * @return void
     */
    public function approve(Process $process)
    {
        return Notification::send($process->user, new ProcessNotifyer($process, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Process $process
     *
     * @return void
     */
    public function publish(Process $process)
    {
        return Notification::send($process->user, new ProcessNotifyer($process, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Process $process
     *
     * @return void
     */
    public function archive(Process $process)
    {
        return Notification::send($process->user, new ProcessNotifyer($process, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Process $process
     *
     * @return void
     */
    public function unpublish(Process $process)
    {
        return Notification::send($process->user, new ProcessNotifyer($process, 'unpublish'));;

    }
}
