<?php

namespace Litepie\Workflow\Workflow;

use Litepie\Workflow\Models\Process;
use Validator;

class ProcessValidator
{

    /**
     * Determine if the given process is valid for complete status.
     *
     * @param Process $process
     *
     * @return bool / Validator
     */
    public function complete(Process $process)
    {
        return Validator::make($process->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given process is valid for verify status.
     *
     * @param Process $process
     *
     * @return bool / Validator
     */
    public function verify(Process $process)
    {
        return Validator::make($process->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given process is valid for approve status.
     *
     * @param Process $process
     *
     * @return bool / Validator
     */
    public function approve(Process $process)
    {
        return Validator::make($process->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given process is valid for publish status.
     *
     * @param Process $process
     *
     * @return bool / Validator
     */
    public function publish(Process $process)
    {
        return Validator::make($process->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given process is valid for archive status.
     *
     * @param Process $process
     *
     * @return bool / Validator
     */
    public function archive(Process $process)
    {
        return Validator::make($process->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given process is valid for unpublish status.
     *
     * @param Process $process
     *
     * @return bool / Validator
     */
    public function unpublish(Process $process)
    {
        return Validator::make($process->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
