<?php

namespace Litecms\BCategory\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\BCategory\Http\Requests\BCategoryRequest;
use Litecms\BCategory\Interfaces\BCategoryRepositoryInterface;
use Litecms\BCategory\Models\BCategory;

/**
 * Resource controller class for b_category.
 */
class BCategoryResourceController extends BaseController
{

    /**
     * Initialize b_category resource controller.
     *
     * @param type BCategoryRepositoryInterface $b_category
     *
     * @return null
     */
    public function __construct(BCategoryRepositoryInterface $b_category)
    {
        parent::__construct();
        $this->repository = $b_category;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\BCategory\Repositories\Criteria\BCategoryResourceCriteria::class);
    }

    /**
     * Display a list of b_category.
     *
     * @return Response
     */
    public function index(BCategoryRequest $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\BCategory\Repositories\Presenter\BCategoryPresenter::class)
                ->$function();
        }

        $b_categories = $this->repository->paginate();

        return $this->response->title(trans('b_category::b_category.names'))
            ->view('b_category::b_category.index', true)
            ->data(compact('b_categories'))
            ->output();
    }

    /**
     * Display b_category.
     *
     * @param Request $request
     * @param Model   $b_category
     *
     * @return Response
     */
    public function show(BCategoryRequest $request, BCategory $b_category)
    {

        if ($b_category->exists) {
            $view = 'b_category::b_category.show';
        } else {
            $view = 'b_category::b_category.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('b_category::b_category.name'))
            ->data(compact('b_category'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new b_category.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(BCategoryRequest $request)
    {

        $b_category = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('b_category::b_category.name')) 
            ->view('b_category::b_category.create', true) 
            ->data(compact('b_category'))
            ->output();
    }

    /**
     * Create new b_category.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(BCategoryRequest $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $b_category                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('b_category::b_category.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('b_category/b_category/' . $b_category->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/b_category/b_category'))
                ->redirect();
        }

    }

    /**
     * Show b_category for editing.
     *
     * @param Request $request
     * @param Model   $b_category
     *
     * @return Response
     */
    public function edit(BCategoryRequest $request, BCategory $b_category)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('b_category::b_category.name'))
            ->view('b_category::b_category.edit', true)
            ->data(compact('b_category'))
            ->output();
    }

    /**
     * Update the b_category.
     *
     * @param Request $request
     * @param Model   $b_category
     *
     * @return Response
     */
    public function update(BCategoryRequest $request, BCategory $b_category)
    {
        try {
            $attributes = $request->all();

            $b_category->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('b_category::b_category.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('b_category/b_category/' . $b_category->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('b_category/b_category/' . $b_category->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the b_category.
     *
     * @param Model   $b_category
     *
     * @return Response
     */
    public function destroy(BCategoryRequest $request, BCategory $b_category)
    {
        try {

            $b_category->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('b_category::b_category.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('b_category/b_category/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('b_category/b_category/' . $b_category->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple b_category.
     *
     * @param Model   $b_category
     *
     * @return Response
     */
    public function delete(BCategoryRequest $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('b_category::b_category.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('b_category/b_category'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/b_category/b_category'))
                ->redirect();
        }

    }

    /**
     * Restore deleted b_categories.
     *
     * @param Model   $b_category
     *
     * @return Response
     */
    public function restore(BCategoryRequest $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('b_category::b_category.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/b_category/b_category'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/b_category/b_category/'))
                ->redirect();
        }

    }

}
