<?php

namespace Litecms\BCategory\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\BCategory\Models\BCategory;

class BCategoryPolicy
{

    /**
     * Determine if the given user can view the b_category.
     *
     * @param UserPolicy $user
     * @param BCategory $b_category
     *
     * @return bool
     */
    public function view(UserPolicy $user, BCategory $b_category)
    {
        if ($user->canDo('b_category.b_category.view') && $user->isAdmin()) {
            return true;
        }

        return $b_category->user_id == user_id() && $b_category->user_type == user_type();
    }

    /**
     * Determine if the given user can create a b_category.
     *
     * @param UserPolicy $user
     * @param BCategory $b_category
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('b_category.b_category.create');
    }

    /**
     * Determine if the given user can update the given b_category.
     *
     * @param UserPolicy $user
     * @param BCategory $b_category
     *
     * @return bool
     */
    public function update(UserPolicy $user, BCategory $b_category)
    {
        if ($user->canDo('b_category.b_category.edit') && $user->isAdmin()) {
            return true;
        }

        return $b_category->user_id == user_id() && $b_category->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given b_category.
     *
     * @param UserPolicy $user
     * @param BCategory $b_category
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, BCategory $b_category)
    {
        return $b_category->user_id == user_id() && $b_category->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given b_category.
     *
     * @param UserPolicy $user
     * @param BCategory $b_category
     *
     * @return bool
     */
    public function verify(UserPolicy $user, BCategory $b_category)
    {
        if ($user->canDo('b_category.b_category.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given b_category.
     *
     * @param UserPolicy $user
     * @param BCategory $b_category
     *
     * @return bool
     */
    public function approve(UserPolicy $user, BCategory $b_category)
    {
        if ($user->canDo('b_category.b_category.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
