<?php

namespace Litecms\BCategory\Providers;

use Illuminate\Support\ServiceProvider;

class BCategoryServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'b_category');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'b_category');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.b_category', function ($app) {
            return $this->app->make('Litecms\BCategory\BCategory');
        });

        // Bind BCategory to repository
        $this->app->bind(
            'Litecms\BCategory\Interfaces\BCategoryRepositoryInterface',
            \Litecms\BCategory\Repositories\Eloquent\BCategoryRepository::class
        );        // Bind BCategory to repository
        $this->app->bind(
            'Litecms\BCategory\Interfaces\BCategoryRepositoryInterface',
            \Litecms\BCategory\Repositories\Eloquent\BCategoryRepository::class
        );

        $this->app->register(\Litecms\BCategory\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\BCategory\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.b_category'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/b_category.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/b_category')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/b_category')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
