<?php

namespace Litecms\BCategory\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BCategoryTransformer extends TransformerAbstract
{
    public function transform(\Litecms\BCategory\Models\BCategory $b_category)
    {
        return [
            'id'                => $b_category->getRouteKey(),
            'key'               => [
                'public'    => $b_category->getPublicKey(),
                'route'     => $b_category->getRouteKey(),
            ], 
            'name'              => $b_category->name,
            'status'            => $b_category->status,
            'url'               => [
                'public'    => trans_url('b_category/'.$b_category->getPublicKey()),
                'user'      => guard_url('b_category/b_category/'.$b_category->getRouteKey()),
            ], 
            'status'            => trans('app.'.$b_category->status),
            'created_at'        => format_date($b_category->created_at),
            'updated_at'        => format_date($b_category->updated_at),
        ];
    }
}