<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'litecms',

    /*
     * Package.
     */
    'package'   => 'bus_listing',

    /*
     * Modules.
     */
    'modules'   => ['bus_listing'],

    
    'bus_listing'       => [
        'model' => [
            'model'                 => \Litecms\BusListing\Models\BusListing::class,
            'table'                 => 'bus_listings',
            'presenter'             => \Litecms\BusListing\Repositories\Presenter\BusListingPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['name',  'source',  'available_days',  'departure_time',  'transport_partner'],
            'translatables'         => [],
            'upload_folder'         => 'bus_listing/bus_listing',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'BusListing',
            'module'    => 'BusListing',
        ],

    ],
];
